// By EVOLVED
// www.evolved-software.com

#define Specularity 1
#define ParallaxReflection 1

//--------------
// un-tweaks
//--------------
   float4x4 WorldVP:WorldViewProjection; 
   float4x4 World:World;   
   float4x4 ViewInv:ViewInverse; 
   float4x4 ViewProj:ViewProjection; 

//--------------
// tweaks
//--------------
   float2 ViewSize;
   float4 FogColor;
   float4 WaterFogColor;
   float WaterFogHeight;
   float3 AmbientColor;
   float3 LightDirection;
   float3 LightDirectionColor;
   float4x4 LightDirectionShadow;
   float LightRange;
   int DynamicPointCount=0;
   float4 PointPositionX;
   float4 PointPositionY;
   float4 PointPositionZ;
   float4 PointRange;
   float4 PointRed;
   float4 PointGreen;
   float4 PointBlue;
   int DynamicSpotCount=0;
   float4 SpotPositionX;
   float4 SpotPositionY;
   float4 SpotPositionZ;
   float4 SpotRange;
   float4 SpotRed;
   float4 SpotGreen;
   float4 SpotBlue;
   float4 SpotDirX;
   float4 SpotDirY;
   float4 SpotDirZ;
   float4 SpotMin;
   float4 SpotMax;
   float Normalz=0.75;

//--------------
// Textures
//--------------
   texture BaseTexture <string Name = "";>;	
   sampler BaseSampler=sampler_state 
      {
 	Texture=<BaseTexture>;
  	MagFilter=anisotropic;
	MinFilter=anisotropic;
	MipFilter=anisotropic;
	MaxAnisotropy=8;
      };
   texture NormalMapTexture <string Name = "";>;	
   sampler NormalMapSampler=sampler_state 
      {
 	Texture=<NormalMapTexture>;
  	MagFilter=anisotropic;
	MinFilter=anisotropic;
	MipFilter=anisotropic;
	MaxAnisotropy=4;
      };
   texture SecondarysTexture <string Name = "";>;	
   sampler SecondarysSampler=sampler_state 
      {
 	Texture=<SecondarysTexture>;
      };
   texture ReflectionTexture <string Name="";>;
   sampler ReflectionSampler=sampler_state
      {
	Texture=<ReflectionTexture>;
	AddressU=Clamp;
	AddressV=Clamp;
	AddressW=Clamp;
      };
   texture LightsTexture <string Name = "";>;	
   sampler LightsSampler=sampler_state 
      {
 	Texture=<LightsTexture>;
  	MagFilter=None;
	MinFilter=None;
	MipFilter=None;
      };
   texture ShadowTexture <string Name = "";>;	
   sampler ShadowSampler=sampler_state 
      {
 	Texture=<ShadowTexture>;
  	MagFilter=None;
	MinFilter=None;
	MipFilter=None;
	AddressU=Border;
	AddressV=Border;
	AddressW=Border;
      };
   texture DepthTexture <string Name = "";>;	
   sampler DepthSampler=sampler_state 
      {
 	Texture=<DepthTexture>;
	AddressU=Clamp;
	AddressV=Clamp;
      };

//--------------
// structs 
//--------------
   struct Input
     {
 	float4 Pos:POSITION;
    	float2 Tex0:TEXCOORD; 
 	float3 Normal:NORMAL;
 	float3 Tangent:TANGENT;
      };
   struct Out_Lighting
      {
	float4 Pos:POSITION;
 	float2 Tex:TEXCOORD0;
  	float3 WorldPos:TEXCOORD1;
  	float4 TBNRow1:TEXCOORD2;
  	float4 TBNRow2:TEXCOORD3;
  	float4 TBNRow3:TEXCOORD4;
 	float4 LightX:TEXCOORD5;
  	float4 LightY:TEXCOORD6;
  	float4 LightZ:TEXCOORD7;
  	float4 Proj:COLOR0;
      };

//--------------
// vertex shader
//--------------
   Out_Lighting VS_Lighting(Input IN)  
     {
 	Out_Lighting OUT;
  	OUT.Pos=mul(IN.Pos,WorldVP);
	OUT.Tex=IN.Tex0;
	float3 WorldPos=mul(IN.Pos,World);
	OUT.WorldPos=WorldPos;
	float3 ViewVec=ViewInv[3].xyz-WorldPos;
	float3 Normals=normalize(mul(IN.Normal,World)); 
	float3 Tangent=normalize(mul(IN.Tangent,World));
	OUT.TBNRow1.xyz=Tangent;
	OUT.TBNRow2.xyz=cross(Normals,Tangent);
	OUT.TBNRow3.xyz=Normals;
	float4 ShadowProj=mul(float4(WorldPos,1),LightDirectionShadow)*float4(0.5,-0.5,1,0)+float4(0.5,0.5,0.0,0.0);
	float4 ShadowMap=float4(tex2Dlod(ShadowSampler,ShadowProj).x,tex2Dlod(ShadowSampler,ShadowProj+float4(0.0009765625,0.0,0.0,0.0)).x,tex2Dlod(ShadowSampler,ShadowProj+float4(0,0.0009765625,0.0,0.0)).x,tex2Dlod(ShadowSampler,ShadowProj+float4(0.0009765625,0.0009765625,0.0,0.0)).x);
	ShadowMap=saturate(step(ShadowProj.z,ShadowMap)+(1-ceil(ShadowMap)));
	ShadowMap.xy=lerp(ShadowMap.xz,ShadowMap.yw,frac(1024*ShadowProj.x));
	float3 LightingColor=max(dot(LightDirection,Normals),0.0)*LightDirectionColor*lerp(ShadowMap.x,ShadowMap.y,frac(1024.0*ShadowProj.y));
	OUT.LightX.xyz=LightingColor*LightDirection.x, OUT.LightY.xyz=LightingColor*LightDirection.y, OUT.LightZ.xyz=LightingColor*LightDirection.z;
	float LightSegment=clamp(floor(length(ViewVec/LightRange)*16.0),0.0,15.0)*0.0078125;
	int LightCount=tex2Dlod(LightsSampler,float4(0.0,LightSegment,0.0,0.0));
	for (int l=0; l < LightCount; l++) {
	 float LightId=tex2Dlod(LightsSampler,float4((1.0+l)*0.0078125,LightSegment,0.0,0.0))*0.0078125;
	 float4 LightPosition=tex2Dlod(LightsSampler,float4(LightId,0.125,0.0,0.0));
	 float4 LightColor=tex2Dlod(LightsSampler,float4(LightId,0.1328125,0.0,0.0));
	 float4 LightSpot=tex2Dlod(LightsSampler,float4(LightId,0.140625,0.0,0.0));
	 float3 LightVec=LightPosition.xyz-WorldPos;
	 float Attenuation=length(LightVec);
	 LightVec /=Attenuation;
	 float Light=max(dot(LightVec,Normals),0.0);
	 Light *=saturate((dot(LightVec,LightSpot.xyz)-LightSpot.w)/LightColor.w);
	 float3 LightingColor=LightColor.xyz*Light*max(1.0/(Attenuation/LightPosition.w)-1.0,0.0);
         OUT.LightX.xyz +=LightingColor*LightVec.x, OUT.LightY.xyz +=LightingColor*LightVec.y, OUT.LightZ.xyz +=LightingColor*LightVec.z;
	}
	#if ParallaxReflection == 0
	 OUT.TBNRow1.w=0.0, OUT.TBNRow2.w=0.0, OUT.TBNRow3.w=0.0;
	 OUT.LightX.w=0.0, OUT.LightY.w=0.0, OUT.LightZ.w=0.0;
	#else
	 float4 MinMaxX=tex2Dlod(ReflectionSampler,float4(0.0,0.0,0.0,0.0));
	 float4 MinMaxY=tex2Dlod(ReflectionSampler,float4(0.5,0.0,0.0,0.0));
	 float4 MinMaxZ=tex2Dlod(ReflectionSampler,float4(1.0,0.0,0.0,0.0));
	 float3 BoxMin=float3(MinMaxX.x,MinMaxY.x,MinMaxZ.x)*65025.0+float3(MinMaxX.y,MinMaxY.y,MinMaxZ.y)*255.0;
	 float3 BoxMax=float3(MinMaxX.z,MinMaxY.z,MinMaxZ.z)*65025.0+float3(MinMaxX.w,MinMaxY.w,MinMaxZ.w)*255.0;
	 BoxMin=(BoxMin-32512.0)*4.0;
	 OUT.TBNRow1.w=BoxMin.x, OUT.TBNRow2.w=BoxMin.y, OUT.TBNRow3.w=BoxMin.z;
	 BoxMax=(BoxMax-32512.0)*4.0;
	 OUT.LightX.w=BoxMax.x, OUT.LightY.w=BoxMax.y, OUT.LightZ.w=BoxMax.z;
	#endif
	OUT.Proj=float4(OUT.Pos.x*0.5+0.5*OUT.Pos.w,0.5*OUT.Pos.w-OUT.Pos.y*0.5,OUT.Pos.z*0.5,OUT.Pos.w);
	return OUT;
     }
   Out_Lighting VS_Distortion(Input IN)  
     {
 	Out_Lighting OUT;
  	OUT.Pos=mul(IN.Pos,WorldVP);
	OUT.Tex=IN.Tex0;
	float3 WorldPos=mul(IN.Pos,World);
	OUT.WorldPos=WorldPos;
	float3 ViewVec=ViewInv[3].xyz-WorldPos;
	float3 Normals=normalize(mul(IN.Normal,World)); 
	float3 Tangent=normalize(mul(IN.Tangent,World));
	OUT.TBNRow1.xyz=Tangent;
	OUT.TBNRow2.xyz=cross(Normals,Tangent);
	OUT.TBNRow3.xyz=Normals;
	OUT.LightX=0.0, OUT.LightY=0.0, OUT.LightZ=0.0;
	OUT.TBNRow1.w=0.0, OUT.TBNRow2.w=0.0, OUT.TBNRow3.w=0.0;
	OUT.Proj=float4(OUT.Pos.x*0.5+0.5*OUT.Pos.w,0.5*OUT.Pos.w-OUT.Pos.y*0.5,OUT.Pos.z*0.5,OUT.Pos.w);
	return OUT;
     }


//--------------
// pixel shader
//--------------
   float4 PS_Lighting(Out_Lighting IN)  : COLOR
     {
	float4 Diffuse=tex2D(BaseSampler,IN.Tex);
	float4 NormalMap=tex2D(NormalMapSampler,IN.Tex);
	float4 Secondarys=tex2D(SecondarysSampler,IN.Tex);
	float3x3 WorldTBN=float3x3(IN.TBNRow1.xyz,IN.TBNRow2.xyz,IN.TBNRow3.xyz);
	float3 Normals=normalize(mul(float3(NormalMap.yw*2.0-1.0,Normalz),WorldTBN));
	float3 ViewVec=normalize(ViewInv[3].xyz-IN.WorldPos);
	float ViewNormal=max(dot(ViewVec,Normals),0.0);
	Diffuse.xyz=pow(Diffuse.xyz,2.2);
	float3 Specular=lerp(0.04,Diffuse.xyz,NormalMap.x);
	Specular +=(1.0-Specular)*(1.0-NormalMap.z)*pow(1.0-ViewNormal,5.0);
	float3 Lighting=max(IN.LightX.xyz*Normals.x+IN.LightY.xyz*Normals.y+IN.LightZ.xyz*Normals.z,0.0);
	#if Specularity == 1
	 float Distribution=pow(NormalMap.z*NormalMap.z+0.004,2.5);
	 float Denominator=Distribution.x-1.0;
	 float3 LightDirX=normalize(ViewVec+float3(IN.LightX.x,IN.LightY.x,IN.LightZ.x));
	 float3 LightDirY=normalize(ViewVec+float3(IN.LightX.y,IN.LightY.y,IN.LightZ.y));
	 float3 LightDirZ=normalize(ViewVec+float3(IN.LightX.z,IN.LightY.z,IN.LightZ.z));
	 float3 HalfVec=float3(dot(LightDirX,Normals),dot(LightDirY,Normals),dot(LightDirZ,Normals))*Denominator+1.0005;
	 HalfVec=(Distribution/(3.141592*HalfVec*HalfVec))*Lighting;
	 float3 LightSpecular=max(HalfVec.x,max(HalfVec.y,HalfVec.z))*Lighting;
	#else
	 float3 LightSpecular=0.0;
	#endif
	for (int l=0; l < DynamicPointCount; l++) {
	 float3 LightVec=float3(PointPositionX[l],PointPositionY[l],PointPositionZ[l])-IN.WorldPos;
	 float Attenuation=length(LightVec);
	 LightVec /=Attenuation;
	 float3 Light=float3(PointRed[l],PointGreen[l],PointBlue[l])*max(dot(LightVec,Normals),0.0)*max(1.0/(Attenuation/PointRange[l])-1.0,0.0);
	 Lighting +=Light;
	 #if Specularity == 1
	  HalfVec.x=max(dot(normalize(LightVec+ViewVec),Normals),0.0)*Denominator+1.0005;
	  LightSpecular +=(Distribution/(3.141592*HalfVec.x*HalfVec.x))*Light;
	 #endif
	}
	for (int l=0; l < DynamicSpotCount; l++) {
	 float3 LightVec=float3(SpotPositionX[l],SpotPositionY[l],SpotPositionZ[l])-IN.WorldPos;
	 float Attenuation=length(LightVec);
	 LightVec /=Attenuation;
	 float3 Light=float3(SpotRed[l],SpotGreen[l],SpotBlue[l])*max(dot(LightVec,Normals),0.0)*max(1.0/(Attenuation/SpotRange[l])-1.0,0.0);
	 Light *=saturate((dot(LightVec,float3(SpotDirX[l],SpotDirY[l],SpotDirZ[l]))-SpotMin[l])/SpotMax[l]);
	 Lighting +=Light;
	 #if Specularity == 1
	  HalfVec.x=max(dot(normalize(LightVec+ViewVec),Normals),0.0)*Denominator+1.0005;
	  LightSpecular +=(Distribution/(3.141592*HalfVec.x*HalfVec.x))*Light;
	 #endif
	}
	#if ParallaxReflection == 0
	 float3 ViewReflection=reflect(ViewVec,Normals);
        #else
	 float3 BoxMin=float3(IN.TBNRow1.w,IN.TBNRow2.w,IN.TBNRow3.w);
	 float3 BoxMax=float3(IN.LightX.w,IN.LightY.w,IN.LightZ.w);
	 float3 ViewReflection=reflect(-ViewVec,Normals);
	 float3 ReflectionBox=max((BoxMin-IN.WorldPos.xyz)/ViewReflection,(BoxMax-IN.WorldPos.xyz)/ViewReflection);
	 ViewReflection=IN.WorldPos.xyz+ViewReflection*min(min(ReflectionBox.x,ReflectionBox.y),ReflectionBox.z);
	 ViewReflection=-normalize(ViewReflection-(BoxMin+((BoxMax-BoxMin)*0.5)));
	#endif
	float2 Equirectangular=0.3183*float2(atan2(-ViewReflection.z,ViewReflection.x),acos(ViewReflection.y));
	float4 Reflections=tex2Dlod(ReflectionSampler,float4(Equirectangular.x*0.5+0.5,1.0025-Equirectangular.y,0.0,NormalMap.z*5.0));
	LightSpecular +=Reflections.xyz*pow(1.04,Reflections.w*255.0-128.0);
	Lighting +=AmbientColor*Secondarys.y;
	Lighting *=(1.0-Specular)*(1.0-NormalMap.x)*Diffuse.xyz;
	Lighting +=(LightSpecular*Specular)+(Diffuse.xyz*Secondarys.x*32.0);
        float2 FogDist=saturate(1.0-exp(-(IN.Proj.z/float2(FogColor.w,WaterFogColor.w))));
        FogDist.y *=saturate(-IN.WorldPos.y+WaterFogHeight);
	return float4(lerp(lerp(Lighting,FogColor.xyz,FogDist.x),WaterFogColor.xyz,FogDist.y),Diffuse.w);
     }
    float4 PS_Distortion(Out_Lighting IN)  : COLOR
     {
	float Depth=saturate(tex2D(DepthSampler,(IN.Proj.xy/IN.Proj.w)+ViewSize).w-IN.Proj.z);
	float3 ViewVec=ViewInv[3].xyz-IN.WorldPos;
	float ViewDist=length(ViewVec);
	ViewVec=normalize(ViewVec);
	float4 NormalMap=tex2D(NormalMapSampler,IN.Tex.xy);
	float4 Secondarys=tex2D(SecondarysSampler,IN.Tex.xy);
	float3x3 WorldTBN=float3x3(IN.TBNRow1.xyz,IN.TBNRow2.xyz,IN.TBNRow3.xyz);
	float3 Normals=normalize(mul(float3(NormalMap.yw*2.0-1.0,Normalz),WorldTBN));
	float ViewNormal=max(dot(ViewVec,Normals),0.0);
	float3 Distort=normalize(mul(Normals,ViewProj).xyz)*(1.0-ViewNormal)*Secondarys.z;
	ViewNormal=saturate(ViewNormal*2.0);
	return float4(0.5+float2(-Distort.x,Distort.y)*saturate(10.0/(1.0+IN.Proj.z)),1.0,Depth*lerp(tex2D(BaseSampler,IN.Tex).w,ViewNormal,Secondarys.z));
     }

//--------------
// techniques
//--------------
    technique Lighting
      {
 	pass p1
      {		
 	vertexShader=compile vs_3_0 VS_Lighting(); 
 	pixelShader=compile ps_3_0 PS_Lighting();
        ColorWriteEnable=7;
	AlphaBlendEnable=true;
	zwriteenable=false;
      }
      }
    technique Distortion
      {
 	pass p1
      {
 	vertexShader = compile vs_3_0 VS_Distortion();
 	pixelShader  = compile ps_3_0 PS_Distortion();
        ColorWriteEnable=7;
	AlphaBlendEnable=true;
	zwriteenable=false;
      }
      }
